<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
/**
 *
 * Field: Image Gallery Custom
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
class CSSFramework_Option_image_gallery_custom extends CSSFramework_Options {

  public function __construct( $field, $value = '', $unique = '' ) {
    parent::__construct( $field, $value, $unique );
  }

  public function output() {

    echo $this->element_before();

    $value  = $this->element_value();
    $hidden = ( empty( $value ) ) ? ' hidden' : '';
    $visible = ( !empty( $value ) ) ? ' hidden' : '';

    // Settings
    if( isset( $this->field['settings'] ) ) { 
      $settings     = $this->field['settings'];
      $images_path  = $settings['images_path'];
	}


	// Get Preview Image URL
	$path 			= CSSF_DIR . $images_path . $value;
	$uri 			= CSSF_URI . $images_path . $value;
	$ext 			= '.jpg'; // Our default file extension
	$files 			= glob("{$path}.{jpg,jpeg,png,gif}", GLOB_BRACE);

	foreach ($files as $file){
		$info = pathinfo($file);
		$ext = $info["extension"];
	}

	$image_url 		= "{$uri}.{$ext}";


	echo "
		<div class='cssf-image-select'>
    		<div class='cssf-image-preview {$hidden}'><img src='{$image_url}'></i></div>
    		<div class='cssf-field-wrapper-horizontal'>
    			<a href='#' class='cssf-button cssf-button-primary cssf-image-add' data-images-path='{$images_path}'>". __( 'Add image', 'cssf-framework' ) ."</a>
    			<a href='#' class='cssf-button cssf-button-warning cssf-image-remove {$hidden}'>". __( 'Remove image', 'cssf-framework' ) ."</a>
    			<input type='text' name='". $this->element_name() ."' value='{$value}' ". $this->element_class( 'cssf-image-value' ) . $this->element_attributes() ." />
    		</div>
		</div>
	";

    echo $this->element_after();

  }

}
